PSCAD 4.2.0

Settings
 {
 Id = "976141504.1144440520"
 Author = "jayas.jayas"
 Desc = "Single Transmission Line"
 Arch = "windows"
 Options = 0
 Build = 19
 Warn = 7
 Check = 15
 Libs = ""
 Source = ""
 RunInfo = 
  {
  Fin = 0.5
  Step = 5e-005
  Plot = 0.001
  Chat = 0.001
  Brch = 0.0005
  Lat = 100
  Options = 0
  Advanced = 511
  Debug = 0
  StartFile = ""
  OFile = "noname.out"
  SFile = "noname.snp"
  SnapTime = 0.3
  Mruns = 10
  Mrunfile = 0
  StartType = 0
  PlotType = 0
  SnapType = 0
  MrunType = "mrun"
  }


Global_Consts = 
  {
  f = 60.0 [Hz]
  }

 }

Definitions
 {
 Module("Controls")
  {
  Desc = ""
  FileDate = 1144440510
  Nodes = 
   {
   Input("FType",36,-18)
    {
    Type = Integer
    }
   Output("B",36,-36)
    {
    Type = Integer
    Dim  = [2]
    }
   Output("F",36,18)
    {
    Type = Integer
    }
   Output("Ftime",36,0)
    {
    Type = Real
    }
   Output("Fdur",36,36)
    {
    Type = Real
    }
   }

  Graphics = 
   {
   Brush(Solid,Yellow)
   Rectangle(-24,-43,27,42)
   Pen(Gray)
   Brush(,Silver)
   Rectangle(0,-13,3,0)
   Pen(Black)
   Line(27,18,36,18)
   Pen(ByNode)
   Brush(Hollow)
   Rectangle(-4,-18,7,3)
   Pen(Black)
   Line(27,-18,36,-18)
   Text(1,25,"Controls")
   Pen(Gray)
   Brush(Solid,Gray)
   Rectangle(-3,-10,6,-7)
   Pen(Black)
   Line(27,-36,36,-36)
   Line(27,0,37,0)
   Line(27,36,36,36)
   }


  Page(A/A4,Landscape,16,[597,467],100)
   {
   -Sticky-([72,198],0)
    {
    Name = ""
    Font = 1
    Bounds = 72,198,198,234
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "PREFAULT CONTROLS"
    }
   -Sticky-([72,666],0)
    {
    Name = ""
    Font = 1
    Bounds = 72,666,180,702
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "FAULT CONTROLS"
    }
   -ControlPanel-([72,720],0)
    {
    Name = "Fault Location, Type, Start & Duration"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,432,126
    Dial(38324608)
    Dial(38363392)
    Slider(25034368)
    Slider(25032232)
    Slider(38342056)
    }
   -Wire-([1116,864],0,0,-1)
    {
    Vertex="0,0;-18,0"
    }
   0.datalabel([1368,1026],6,0,-1)
    {
    Name = "B1"
    }
   0.datalabel([1368,1044],6,0,-1)
    {
    Name = "B2"
    }
   0.export([1422,1134],4,0,190)
    {
    Name = "F"
    }
   0.datalabel([990,684],3,0,-1)
    {
    Name = "B1T1"
    }
   0.datalabel([990,738],3,0,-1)
    {
    Name = "B1T2"
    }
   0.datalabel([990,792],3,0,-1)
    {
    Name = "B2T1"
    }
   0.var([954,684],0,24890472,20)
    {
    Name = "B1 T1"
    Group = ""
    Display = "0"
    Max = "2"
    Min = "0.0"
    Value = "2.0"
    Units = "s"
    Collect = "1"
    }
   0.var([954,738],0,24891848,40)
    {
    Name = "B1 T2"
    Group = ""
    Display = "0"
    Max = "2.0"
    Min = "0.0"
    Value = "2.0"
    Units = "s"
    Collect = "1"
    }
   0.var([954,792],0,24893824,60)
    {
    Name = "B2 T1"
    Group = ""
    Display = "0"
    Max = "2.0"
    Min = "0.0"
    Value = "2.0"
    Units = "s"
    Collect = "1"
    }
   -Sticky-([954,198],0)
    {
    Name = ""
    Font = 1
    Bounds = 954,198,1062,234
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "BREAKER CONTROLS"
    }
   -Wire-([1116,684],0,0,-1)
    {
    Vertex="0,0;-18,0"
    }
   0.datalabel([990,846],3,0,-1)
    {
    Name = "B2T2"
    }
   0.tbreakn([1062,684],4,0,130)
    {
    NUMS = "2"
    INIT = "0"
    TO1 = "B1T1"
    TO2 = "B1T2"
    }
   -Wire-([630,756],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([666,756],0,0,-1)
    {
    Name = "Tfs"
    }
   -Wire-([630,828],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([666,828],0,0,-1)
    {
    Name = "Tfd"
    }
   0.datalabel([792,792],4,0,-1)
    {
    Name = "Fault"
    }
   0.datalabel([1332,1134],4,0,-1)
    {
    Name = "Fault"
    }
   -Wire-([1332,1134],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.var([954,846],0,24921752,80)
    {
    Name = "B2 T2"
    Group = ""
    Display = "0"
    Max = "2.0"
    Min = "0.0"
    Value = "2.0"
    Units = "s"
    Collect = "1"
    }
   -ControlPanel-([954,396],0)
    {
    Name = "B2 Timing"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,216,126
    Switch(24971736)
    Slider(24893824)
    Slider(24921752)
    }
   0.tbreakn([1062,864],4,0,90)
    {
    NUMS = "2"
    INIT = "0"
    TO1 = "B2T1"
    TO2 = "B2T2"
    }
   -Wire-([1116,720],0,0,-1)
    {
    Vertex="0,0;0,108"
    }
   0.logic([1152,864],6,0,170)
    {
    Type = "1"
    Inv = "0"
    }
   0.datalabel([1080,774],0,0,-1)
    {
    Name = "FType"
    }
   -Wire-([1080,774],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.import([1422,1188],0,0,120)
    {
    Name = "FType"
    }
   0.logic([1152,684],0,0,140)
    {
    Type = "1"
    Inv = "0"
    }
   -Wire-([1188,684],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.var_switch([1188,648],0,24919176,10)
    {
    Name = "42-B1"
    Group = ""
    Display = "0"
    Value = "0"
    Max = "1"
    Min = "0"
    Ton = "O"
    Toff = "C"
    }
   0.datalabel([1296,684],4,0,-1)
    {
    Name = "B1"
    }
   -Wire-([1188,864],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Sticky-([1026,1062],0)
    {
    Name = ""
    Font = 1
    Bounds = 1026,1062,1134,1098
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "Exports to Main Page"
    }
   -Sticky-([954,540],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 954,540,1116,612
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "\
Adjust breaker clearing time (T1)
and reclose time (T2) if needed."
    }
   0.var_switch([1188,810],6,24971736,70)
    {
    Name = "42-B2"
    Group = ""
    Display = "0"
    Value = "0"
    Max = "1"
    Min = "0"
    Ton = "O"
    Toff = "C"
    }
   -Wire-([1224,828],0,0,-1)
    {
    Vertex="0,0;0,-18"
    }
   0.datalabel([1296,828],2,0,-1)
    {
    Name = "B2"
    }
   0.logic([1260,828],0,0,180)
    {
    Type = "2"
    Inv = "0"
    }
   0.logic([1260,684],6,0,150)
    {
    Type = "2"
    Inv = "0"
    }
   0.export([1422,1080],4,0,210)
    {
    Name = "B"
    }
   0.tfaultn([756,792],4,0,160)
    {
    TF = "Tfs"
    DF = "Tfd"
    }
   -Sticky-([504,108],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 504,108,666,216
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "\
Adjust phase angle to obtain
the correct power flow. Adjust
voltage to obtain the matching
VAR flow at each end."
    }
   0.arrow_a([504,216],1,0,-1)
    {
    }
   -ControlPanel-([18,396],0)
    {
    Name = "SOURCE 2"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,504,126
    Slider(38334872)
    Meter(38355704)
    Meter(38357696)
    Slider(38336848)
    Meter(38298472)
    Meter(38349640)
    Meter(38423240)
    }
   -ControlPanel-([18,252],0)
    {
    Name = "SOURCE 1"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,504,126
    Slider(38338832)
    Meter(38353712)
    Meter(38435104)
    Slider(38361120)
    Meter(38380552)
    Meter(38429216)
    Meter(38351720)
    }
   0.var([594,828],0,25032232,50)
    {
    Name = "Duration "
    Group = ""
    Display = "0"
    Max = "1.0"
    Min = "0.0"
    Value = "0.12"
    Units = ""
    Collect = "1"
    }
   0.var([594,756],0,25034368,30)
    {
    Name = "Fault Start "
    Group = ""
    Display = "0"
    Max = "1.0"
    Min = "0.0"
    Value = "0.2"
    Units = "s"
    Collect = "1"
    }
   -Sticky-([180,900],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 180,900,288,1098
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "\
Dial Position:
  1=> A-g
  2=> B-g
  3=> C-g
  4=> AB-g
  5=> AC-g
  6=> BC-g
  7=> ABC-g
  8=> AB 
  9=> AC 
10=>no fault 
"
    }
   -Sticky-([36,900],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 36,900,162,1134
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "\
Dial Position:
  1=> FT1:
          Between Source 
          and B1
  2=> FT2:
          Between Line 
          and B1
  3=> FT3:
          Between Line 
          and B2
  4=> FT4:
          Between Source
          and B2"
    }
   -Sticky-([738,450],0)
    {
    Name = ""
    Font = 1
    Bounds = 738,450,900,594
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "\
To turn the Recorders on, 
click on the switch.
On = Recorder will record data.
Off = Recorder will NOT
          record data.

You can turn on or off 
each recorder individually."
    }
   -Sticky-([756,108],0)
    {
    Name = ""
    Font = 1
    Bounds = 756,108,864,144
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "Playback Recorders"
    }
   -ControlPanel-([954,252],0)
    {
    Name = "B1 Timing"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,216,126
    Switch(24919176)
    Slider(24890472)
    Slider(24891848)
    }
   0.datamerge([1386,1098],4,0,200)
    {
    N = "2"
    Type = "1"
    Disp = "1"
    }
   0.export([1242,1062],4,0,100)
    {
    Name = "Ftime"
    }
   0.datalabel([1170,1062],6,0,-1)
    {
    Name = "Tfs"
    }
   -Wire-([1170,1062],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1170,1098],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.export([1242,1098],4,0,110)
    {
    Name = "Fdur"
    }
   0.datalabel([1170,1098],6,0,-1)
    {
    Name = "Tfd"
    }
   -ControlPanel-([756,306],0)
    {
    Name = "Recorder Control"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,144,126
    Switch(38373040)
    Switch(38370992)
    }
   -ControlPanel-([756,162],0)
    {
    Name = "Recorders"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,144,126
    Slider(38367856)
    Slider(38293368)
    }
   -Divider-([36,630],0)
    {
    Size(900,0)
    3D = 1
    Color = 9
    Style = 0
    Weight = 2
    }
   -Divider-([936,54],0)
    {
    Size(0,1134)
    3D = 1
    Color = 9
    Style = 0
    Weight = 2
    }
   -Divider-([702,54],0)
    {
    Size(0,576)
    3D = 1
    Color = 9
    Style = 0
    Weight = 2
    }
   }
  }
 Module("Plots")
  {
  Desc = ""
  FileDate = 1144440510
  Nodes = 
   {
   }

  Graphics = 
   {
   Brush(Solid,Yellow)
   Rectangle(-24,-43,27,30)
   Line(-13,-1,-13,-21)
   Line(-18,-4,21,-4)
   Line(-13,-4,-4,-13)
   Line(-4,-13,1,-10)
   Line(6,-16,12,-13)
   Pen(Gray)
   Line(27,28,27,-43)
   Pen(Black)
   Line(1,-10,6,-16)
   Text(1,-28,"Plots")
   }


  Page(A/A4,Landscape,16,[597,467],100)
   {
   -Plot-([846,90],0)
    {
    Title = "Plots at B2"
    Draw = 1
    Area = [0,0,630,1062]
    Posn = [846,90]
    Icon = [-1,-1]
    Extents = 0,0,630,1062
    XLabel = ""
    AutoPan = "false,75"
    Graph([0,0],[0,0,630,255],"Voltage")
     {
     Options = 9
     Units = ""
     Curve(38400160,"V2",0,,,)
     }
    Graph([0,255],[0,0,630,254],"Current")
     {
     Options = 9
     Units = ""
     Curve(25596480,"I2",0,,,)
     }
    Graph([0,509],[0,0,630,254],"Current")
     {
     Options = 9
     Units = ""
     Curve(38317432,"I20",0,,,)
     }
    PGraph([0,763],[0,0,630,236],"PolyGraph")
     {
     Options = 2
     Curve(25602792,"Br2a",0,,,)
     Curve(25607152,"Br2b",1,,,)
     Curve(38433200,"Br2c",2,,,)
     }
    }
   -Plot-([108,90],0)
    {
    Title = "Plots at B1"
    Draw = 1
    Area = [0,0,630,1062]
    Posn = [108,90]
    Icon = [-1,-1]
    Extents = 0,0,630,1062
    XLabel = ""
    AutoPan = "false,75"
    Graph([0,0],[0,0,630,255],"Voltage")
     {
     Options = 9
     Units = ""
     Curve(38296480,"V1",0,,,)
     }
    Graph([0,255],[0,0,630,254],"Current")
     {
     Options = 9
     Units = ""
     Curve(38437096,"I1",0,,,)
     }
    Graph([0,509],[0,0,630,254],"Current")
     {
     Options = 9
     Units = ""
     Curve(38314904,"I10",0,,,)
     }
    PGraph([0,763],[0,0,630,236],"PolyGraph")
     {
     Options = 2
     Curve(25599872,"Br1a",0,,,)
     Curve(25605248,"Br1b",1,,,)
     Curve(38290520,"Br1c",2,,,)
     }
    }
   }
  }
 Module("Main")
  {
  Desc = "Main Page"
  FileDate = 1144440510
  Nodes = 
   {
   }

  Graphics = 
   {
   Rectangle(-18,-18,18,18)
   }


  Page(A/A4,Landscape,16,[597,467],100)
   {
   0.datalabel([900,576],0,0,-1)
    {
    Name = "FT4"
    }
   0.datalabel([720,576],0,0,-1)
    {
    Name = "FT3"
    }
   0.datalabel([504,576],0,0,-1)
    {
    Name = "FT2"
    }
   -Wire-([306,450],0,0,-1)
    {
    Vertex="0,0;0,108"
    }
   -Wire-([738,450],0,0,-1)
    {
    Vertex="0,0;0,108"
    }
   -Wire-([918,450],0,0,-1)
    {
    Vertex="0,0;0,108"
    }
   0.datalabel([1332,1044],0,0,-1)
    {
    Name = "I2"
    }
   0.datalabel([1332,1080],0,0,-1)
    {
    Name = "I2B"
    }
   0.pgb([1368,1044],0,25596480,570)
    {
    Name = "I2"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-4.0"
    Max = "6.0"
    }
   0.datalabel([1062,918],0,0,-1)
    {
    Name = "Br1A"
    }
   0.datalabel([1062,954],0,0,-1)
    {
    Name = "Br1B"
    }
   0.datalabel([1062,990],0,0,-1)
    {
    Name = "Br1C"
    }
   0.pgb([1098,918],0,25599872,710)
    {
    Name = "Br1a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-0.1"
    Max = "0.1"
    }
   0.datalabel([1458,918],0,0,-1)
    {
    Name = "Br2A"
    }
   0.datalabel([1458,954],0,0,-1)
    {
    Name = "Br2B"
    }
   0.pgb([1494,918],0,25602792,690)
    {
    Name = "Br2a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-0.1"
    Max = "0.1"
    }
   0.datalabel([1062,1044],0,0,-1)
    {
    Name = "P1"
    }
   0.pgb([1098,954],0,25605248,700)
    {
    Name = "Br1b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-0.1"
    Max = "0.1"
    }
   0.pgb([1494,954],0,25607152,670)
    {
    Name = "Br2b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-0.1"
    Max = "0.1"
    }
   0.datalabel([486,828],2,0,-1)
    {
    Name = "I1A"
    }
   0.datalabel([522,828],2,0,-1)
    {
    Name = "I1B"
    }
   0.datalabel([558,828],2,0,-1)
    {
    Name = "I1C"
    }
   0.datalabel([486,1044],2,0,-1)
    {
    Name = "I2A"
    }
   0.datalabel([522,1044],2,0,-1)
    {
    Name = "I2B"
    }
   0.datalabel([558,1044],2,0,-1)
    {
    Name = "I2C"
    }
   0.datalabel([936,918],2,0,-1)
    {
    Name = "V1"
    }
   0.datalabel([936,954],2,0,-1)
    {
    Name = "V1B"
    }
   0.datalabel([1332,954],2,0,-1)
    {
    Name = "V2B"
    }
   0.datalabel([378,828],2,0,-1)
    {
    Name = "V1A"
    }
   0.datalabel([414,828],2,0,-1)
    {
    Name = "V1B"
    }
   0.datalabel([450,828],2,0,-1)
    {
    Name = "V1C"
    }
   0.datalabel([414,1044],6,0,-1)
    {
    Name = "V2B"
    }
   0.datalabel([450,1044],6,0,-1)
    {
    Name = "V2C"
    }
   -Wire-([360,450],0,0,-1)
    {
    Vertex="0,0;-108,0"
    }
   -Wire-([864,450],0,0,-1)
    {
    Vertex="0,0;108,0"
    }
   -Wire-([288,936],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([306,1116],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([288,936],0,0,-1)
    {
    Vertex="0,0;0,216"
    }
   -Wire-([288,1152],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([288,900],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([1062,1116],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1062,1116],0,0,-1)
    {
    Name = "S1W"
    }
   -Wire-([1062,1152],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1062,1152],0,0,-1)
    {
    Name = "S1Q"
    }
   -Wire-([1458,1116],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1458,1152],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1458,1152],0,0,-1)
    {
    Name = "S2Q"
    }
   0.datalabel([1458,1116],0,0,-1)
    {
    Name = "S2W"
    }
   -Wire-([1458,1080],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1458,1080],0,0,-1)
    {
    Name = "Q2"
    }
   -Wire-([1458,1044],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1458,1044],0,0,-1)
    {
    Name = "P2"
    }
   -Wire-([1458,990],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1458,954],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1458,918],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1458,990],0,0,-1)
    {
    Name = "Br2C"
    }
   0.datalabel([1332,1116],0,0,-1)
    {
    Name = "I2C"
    }
   -Wire-([1332,1116],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1332,1044],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1062,918],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1062,954],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1062,990],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1062,1044],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1062,1080],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1332,990],2,0,-1)
    {
    Name = "V2C"
    }
   0.datatap([450,1044],0,0,270)
    {
    Index = "3"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([414,1044],0,0,250)
    {
    Index = "2"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([936,990],2,0,-1)
    {
    Name = "V1C"
    }
   0.datalabel([1062,1080],0,0,-1)
    {
    Name = "Q1"
    }
   0.pgb([1098,990],0,38290520,680)
    {
    Name = "Br1c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-0.1"
    Max = "0.1"
    }
   0.datatap([378,1044],0,0,240)
    {
    Index = "1"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   -Wire-([324,1026],0,0,-1)
    {
    Vertex="0,0;108,0"
    }
   0.var([252,936],0,38293368,150)
    {
    Name = "Stop"
    Group = ""
    Display = "0"
    Max = "1.0"
    Min = "0.0"
    Value = "0.5"
    Units = "s"
    Collect = "1"
    }
   0.datatap([1422,612],2,0,380)
    {
    Index = "2"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([1422,612],6,0,-1)
    {
    Name = "B2"
    }
   0.pgb([972,918],0,38296480,170)
    {
    Name = "V1"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-300.0"
    Max = "300.0"
    }
   0.pgb([1332,828],0,38298472,160)
    {
    Name = "V2rms"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "220"
    Max = "250"
    }
   0.datatap([1386,612],2,0,390)
    {
    Index = "1"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([324,576],0,0,-1)
    {
    Name = "FT1"
    }
   0.datalabel([684,846],2,0,-1)
    {
    Name = "FT1"
    }
   0.datalabel([720,846],2,0,-1)
    {
    Name = "FT2"
    }
   0.datalabel([792,846],2,0,-1)
    {
    Name = "FT4"
    }
   0.datalabel([324,594],0,0,-1)
    {
    Name = "F1"
    }
   0.datalabel([684,1098],0,0,-1)
    {
    Name = "F1"
    }
   0.datalabel([720,594],0,0,-1)
    {
    Name = "F3"
    }
   0.datalabel([900,594],0,0,-1)
    {
    Name = "F4"
    }
   0.datalabel([792,1098],0,0,-1)
    {
    Name = "F4"
    }
   0.datalabel([1386,612],6,0,-1)
    {
    Name = "B1"
    }
   0.datalabel([1404,684],4,0,-1)
    {
    Name = "Fault"
    }
   0.datalabel([738,1008],2,0,-1)
    {
    Name = "Fault"
    }
   0.datalabel([504,594],0,0,-1)
    {
    Name = "F2"
    }
   0.breaker3([828,450],0,0,400)
    {
    Ctrl = "0"
    OPCUR = "0"
    ENAB = "0"
    CLVL = "0.0"
    View = "1"
    ViewB = "1"
    DisPQ = "1"
    NAME = "B2"
    NAMEA = "BRKA"
    NAMEB = "BRKB"
    NAMEC = "BRKC"
    ROFF = "1.0e6 [ohm]"
    RON = "0.1 [ohm]"
    PRER = "0.5 [ohm]"
    TDA = "0.0 [s]"
    TDB = "0.0 [s]"
    TDC = "0.0 [s]"
    TDRA = "0.05 [s]"
    TDRB = "0.05 [s]"
    TDRC = "0.05 [s]"
    PostIns = "0"
    TDBOA = "0.005"
    IBRA = "I2A"
    IBRB = "I2B"
    IBRC = "I2C"
    IBR0 = "I20"
    SBRA = "Br2A"
    SBRB = "Br2B"
    SBRC = "Br2C"
    BP = "P2"
    BQ = "Q2"
    BOpen1 = "0"
    BOpen2 = "0"
    BOpen3 = "0"
    P = "116.7 [MW]"
    Q = "-18.56 [MVAR]"
    }
   0.pgb([972,1116],0,38309984,540)
    {
    Name = "I1c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.pgb([1368,1116],0,38311840,490)
    {
    Name = "I2c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   -Wire-([1332,1152],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([936,1152],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([936,1152],0,0,-1)
    {
    Name = "I10"
    }
   0.pgb([972,1152],0,38314904,500)
    {
    Name = "I10"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-0.4"
    Max = "0.6"
    }
   0.datalabel([1332,1152],0,0,-1)
    {
    Name = "I20"
    }
   0.pgb([1368,1152],0,38317432,460)
    {
    Name = "I20"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-1.5"
    Max = "2.0"
    }
   0.datatap([684,846],6,0,770)
    {
    Index = "1"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([720,846],6,0,760)
    {
    Index = "2"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([756,846],6,0,750)
    {
    Index = "3"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([792,846],6,0,740)
    {
    Index = "4"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([756,846],2,0,-1)
    {
    Name = "FT3"
    }
   -Wire-([666,1080],0,0,-1)
    {
    Vertex="0,0;108,0"
    }
   0.datatap([792,1098],0,0,580)
    {
    Index = "4"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([720,1098],0,0,-1)
    {
    Name = "F2"
    }
   0.datalabel([756,1098],0,0,-1)
    {
    Name = "F3"
    }
   0.var_pot([630,972],0,38324608,180)
    {
    Name = "Fault location"
    Group = ""
    Display = "0"
    NDP = "4"
    Value = "3"
    F1 = "1.0"
    F2 = "2.0"
    F3 = "3.0"
    F4 = "4.0"
    F5 = "5.0"
    F6 = "6.0"
    F7 = "7.0"
    F8 = "8.0"
    F9 = "9.0"
    F10 = "10.0"
    }
   0.unity([702,972],0,0,190)
    {
    IType = "2"
    OType = "1"
    }
   0.unity([738,972],4,0,360)
    {
    IType = "2"
    OType = "1"
    }
   -Wire-([702,936],0,0,-1)
    {
    Vertex="0,0;0,72"
    }
   -Wire-([738,936],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   -Wire-([666,864],0,0,-1)
    {
    Vertex="0,0;108,0"
    }
   0.mux_array([720,900],0,0,720)
    {
    DPath = "0"
    }
   0.datalabel([738,972],5,0,-1)
    {
    Name = "FType"
    }
   0.var([990,522],5,38334872,50)
    {
    Name = "Ph Angle"
    Group = "SS2"
    Display = "0"
    Max = "180"
    Min = "-180"
    Value = "20.0"
    Units = "deg"
    Collect = "1"
    }
   0.var([1044,522],5,38336848,60)
    {
    Name = "Voltage"
    Group = "SS2"
    Display = "0"
    Max = "500"
    Min = "0.0"
    Value = "230.0"
    Units = "kV"
    Collect = "1"
    }
   0.var([234,522],3,38338832,40)
    {
    Name = "Ph Angle"
    Group = "SS1"
    Display = "0"
    Max = "180"
    Min = "0.0"
    Value = "0.0"
    Units = "deg"
    Collect = "1"
    }
   -Sticky-([162,558],0)
    {
    Name = ""
    Font = 1
    Bounds = 162,558,252,594
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "SUBSTATION 1"
    }
   0.tpflt([936,558],4,0,780)
    {
    Ctype = "1"
    OpCur = "0"
    Grnd = "1"
    View = "1"
    CLVL = "0.0"
    RON = "Ron"
    ROFF = "1.0E6 [ohm]"
    A = "1"
    B = "0"
    C = "0"
    G = "1"
    Ifla = ""
    Iflb = ""
    Iflc = ""
    AG1 = "0"
    }
   0.var([666,1170],0,38342056,320)
    {
    Name = "Rf"
    Group = ""
    Display = "0"
    Max = "50"
    Min = "0.001"
    Value = "0.001"
    Units = "ohm"
    Collect = "1"
    }
   -Sticky-([900,810],0)
    {
    Name = ""
    Font = 1
    Bounds = 900,810,1008,846
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "OUTPUT CHANNELS"
    }
   0.datalabel([558,972],0,0,-1)
    {
    Name = "Fault"
    }
   0.datalabel([558,1188],0,0,-1)
    {
    Name = "Fault"
    }
   0.annotation([666,1152],0,0,-1)
    {
    AL1 = "Rf"
    AL2 = ""
    }
   0.tpflt([288,558],0,0,810)
    {
    Ctype = "1"
    OpCur = "0"
    Grnd = "1"
    View = "1"
    CLVL = "0.0"
    RON = "Ron"
    ROFF = "1.0E6 [ohm]"
    A = "1"
    B = "0"
    C = "0"
    G = "1"
    Ifla = ""
    Iflb = ""
    Iflc = ""
    AG1 = "0"
    }
   -Wire-([702,1170],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.datalabel([756,1170],0,0,-1)
    {
    Name = "Ron"
    }
   0.tpflt([756,558],4,0,790)
    {
    Ctype = "1"
    OpCur = "0"
    Grnd = "1"
    View = "1"
    CLVL = "0.0"
    RON = "Ron"
    ROFF = "1.0E6 [ohm]"
    A = "1"
    B = "0"
    C = "0"
    G = "1"
    Ifla = ""
    Iflb = ""
    Iflc = ""
    AG1 = "0"
    }
   0.pgb([1494,1044],0,38349640,550)
    {
    Name = "P2"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "MW"
    mrun = "0"
    Pol = "0"
    Min = "-150"
    Max = "150"
    }
   0.pgb([1098,1080],0,38351720,560)
    {
    Name = "Q1"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "MVAR"
    mrun = "0"
    Pol = "0"
    Min = "-30"
    Max = "30"
    }
   0.pgb([1098,1116],0,38353712,520)
    {
    Name = "S1W"
    Group = ""
    Display = "0"
    Scale = "1"
    Units = "MW"
    mrun = "0"
    Pol = "0"
    Min = "-300"
    Max = "300"
    }
   0.pgb([1494,1116],0,38355704,470)
    {
    Name = "S2W"
    Group = ""
    Display = "0"
    Scale = "1"
    Units = "MW"
    mrun = "0"
    Pol = "0"
    Min = "-300"
    Max = "300"
    }
   0.pgb([1494,1152],0,38357696,450)
    {
    Name = "S2Q"
    Group = ""
    Display = "0"
    Scale = "1"
    Units = "MVAR"
    mrun = "0"
    Pol = "0"
    Min = "-100"
    Max = "100"
    }
   0.breaker3([396,450],4,0,410)
    {
    Ctrl = "0"
    OPCUR = "0"
    ENAB = "0"
    CLVL = "0.0"
    View = "1"
    ViewB = "1"
    DisPQ = "1"
    NAME = "B1"
    NAMEA = "BRKA"
    NAMEB = "BRKB"
    NAMEC = "BRKC"
    ROFF = "1.0e6 [ohm]"
    RON = "0.1 [ohm]"
    PRER = "0.5 [ohm]"
    TDA = "0.0 [s]"
    TDB = "0.0 [s]"
    TDC = "0.0 [s]"
    TDRA = "0.05 [s]"
    TDRB = "0.05 [s]"
    TDRC = "0.05 [s]"
    PostIns = "0"
    TDBOA = "0.005"
    IBRA = "I1A"
    IBRB = "I1B"
    IBRC = "I1C"
    IBR0 = "I10"
    SBRA = "Br1A"
    SBRB = "Br1B"
    SBRC = "Br1C"
    BP = "P1"
    BQ = "Q1"
    BOpen1 = "0"
    BOpen2 = "0"
    BOpen3 = "0"
    P = "-114.8 [MW]"
    Q = "14.83 [MVAR]"
    }
   0.var([180,522],3,38361120,30)
    {
    Name = "Voltage"
    Group = "SS1"
    Display = "0"
    Max = "500"
    Min = "0.0"
    Value = "230.0"
    Units = "kV"
    Collect = "1"
    }
   -Wire-([486,450],0,0,-1)
    {
    Vertex="0,0;0,108"
    }
   0.var_pot([810,972],2,38363392,210)
    {
    Name = "Fault Type"
    Group = ""
    Display = "0"
    NDP = "10"
    Value = "4"
    F1 = "1.0"
    F2 = "2.0"
    F3 = "3.0"
    F4 = "4.0"
    F5 = "5.0"
    F6 = "6.0"
    F7 = "7.0"
    F8 = "8.0"
    F9 = "9.0"
    F10 = "0"
    }
   -Wire-([288,900],0,0,-1)
    {
    Vertex="0,0;-90,0"
    }
   -Wire-([90,1152],0,0,-1)
    {
    Vertex="0,0;0,-216"
    }
   -Wire-([126,936],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   -Wire-([126,1152],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   0.select([162,1116],6,0,310)
    {
    A = "1"
    DPath = "1"
    COM = "Selector"
    }
   -Wire-([306,1116],0,0,-1)
    {
    Vertex="0,0;-108,0"
    }
   0.select([162,900],6,0,350)
    {
    A = "1"
    DPath = "1"
    COM = "Selector"
    }
   0.var([54,936],0,38367856,130)
    {
    Name = "Start"
    Group = ""
    Display = "0"
    Max = "1.0"
    Min = "0.0"
    Value = "0.15"
    Units = "s"
    Collect = "1"
    }
   0.const([90,900],0,0,120)
    {
    Name = ""
    Value = "10.0"
    }
   0.const([126,1080],1,0,290)
    {
    Name = ""
    Value = "10.0"
    }
   0.var_switch([162,1044],1,38370992,230)
    {
    Name = "en Record2"
    Group = ""
    Display = "0"
    Value = "1"
    Max = "1"
    Min = "0"
    Ton = "ON"
    Toff = "OFF"
    }
   0.var_switch([162,828],1,38373040,80)
    {
    Name = "en Record1"
    Group = ""
    Display = "0"
    Value = "1"
    Max = "1"
    Min = "0"
    Ton = "ON"
    Toff = "OFF"
    }
   0.datalabel([1404,648],2,0,-1)
    {
    Name = "FType"
    }
   -Wire-([1404,630],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Wire-([1476,648],0,0,-1)
    {
    Vertex="0,0;-72,0"
    }
   -Wire-([1476,684],0,0,-1)
    {
    Vertex="0,0;-72,0"
    }
   -Wire-([918,990],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([1278,72],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   0.datatap([756,1098],0,0,600)
    {
    Index = "3"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([684,1098],0,0,620)
    {
    Index = "1"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([720,1098],0,0,610)
    {
    Index = "2"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.tpflt([468,558],0,0,800)
    {
    Ctype = "1"
    OpCur = "0"
    Grnd = "1"
    View = "1"
    CLVL = "0.0"
    RON = "Ron"
    ROFF = "1.0E6 [ohm]"
    A = "1"
    B = "0"
    C = "0"
    G = "1"
    Ifla = ""
    Iflb = ""
    Iflc = ""
    AG1 = "0"
    }
   0.source3R([216,450],6,0,330)
    {
    Name = "Source1"
    MVA = "100.0 [MVA]"
    Vm = "230.0 [kV]"
    F = "$(f)"
    Tc = "0.05 [s]"
    Ideal = "0"
    ZSeq = "1"
    Imp = "1"
    View = "1"
    details = "1"
    Z1 = "52.9 [ohm]"
    Phi1 = "80.0 [deg]"
    R1p = "1.0 [ohm]"
    X1p = "0.1 [ohm]"
    Z0 = "52.9 [ohm]"
    Phi0 = "80.0 [deg]"
    R0p = "1.0 [ohm]"
    X0p = "0.1 [ohm]"
    P = "S1W"
    Q = "S1Q"
    Ia = ""
    Ib = ""
    Ic = ""
    }
   0.pgb([1188,828],0,38380552,140)
    {
    Name = "V1rms"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "220"
    Max = "250"
    }
   0.datalabel([1278,72],0,0,-1)
    {
    Name = "Fstart"
    }
   0.datalabel([1278,180],0,0,-1)
    {
    Name = "Fstart"
    }
   0.datalabel([1278,90],0,0,-1)
    {
    Name = "Fltdur"
    }
   0.datalabel([1278,198],0,0,-1)
    {
    Name = "Fltdur"
    }
   -Wire-([1278,666],0,0,-1)
    {
    Vertex="0,0;198,0"
    }
   0.datalabel([1278,666],6,0,-1)
    {
    Name = "Fstart"
    }
   -Wire-([1296,702],0,0,-1)
    {
    Vertex="0,0;180,0"
    }
   0.datalabel([1296,702],6,0,-1)
    {
    Name = "Fltdur"
    }
   0.mux_array([720,1044],6,0,420)
    {
    DPath = "0"
    }
   0.source3R([1008,450],2,0,340)
    {
    Name = "Source2"
    MVA = "100.0 [MVA]"
    Vm = "230.0 [kV]"
    F = "$(f)"
    Tc = "0.05 [s]"
    Ideal = "0"
    ZSeq = "1"
    Imp = "1"
    View = "1"
    details = "1"
    Z1 = "52.9 [ohm]"
    Phi1 = "80.0 [deg]"
    R1p = "1.0 [ohm]"
    X1p = "0.1 [ohm]"
    Z0 = "52.9 [ohm]"
    Phi0 = "80.0 [deg]"
    R0p = "1.0 [ohm]"
    X0p = "0.1 [ohm]"
    P = "S2W"
    Q = "S2Q"
    Ia = ""
    Ib = ""
    Ic = ""
    }
   -Sticky-([54,18],0)
    {
    Name = ""
    Font = 1
    Bounds = 54,18,846,180
    Alignment = 0
    Style = 0
    Arrow = 0
    Color = 0,15792890
    Text = "\
Description: 
- Two Thevinen Impedance sources connected via one 100km transmission line.
- System voltage is 230kV settable via source equivalents.
- Simulates two substations connected via one transmission line.
- Four fault positions for full fault control ahead and behind station relays.
- Two breakers are independently timed controlled. (Default is closed).
- Independent breaker pole tripping is possible.
- Includes two Doble State output file components, which create out1.ss1 and out2.ss1, ready to read into Doble ProTesT software.
"
    }
   0.datalabel([1278,144],2,0,-1)
    {
    Name = "I1"
    }
   -Wire-([1278,90],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Wire-([1278,144],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   0.datalabel([1278,252],2,0,-1)
    {
    Name = "I2"
    }
   -Wire-([1278,180],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Wire-([1278,198],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Wire-([1278,234],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Wire-([1278,252],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   0.datatap([378,828],0,0,90)
    {
    Index = "1"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([414,828],0,0,100)
    {
    Index = "2"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([450,828],0,0,110)
    {
    Index = "3"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   -Wire-([936,918],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([918,954],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.pgb([1368,918],0,38400160,220)
    {
    Name = "V2"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-300.0"
    Max = "300.0"
    }
   -Wire-([1332,918],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1332,918],2,0,-1)
    {
    Name = "V2"
    }
   -Wire-([1314,954],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([1314,990],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([1332,1080],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.pgb([972,1080],0,38403248,590)
    {
    Name = "I1b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   -Wire-([1314,1080],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   0.datalabel([936,1044],2,0,-1)
    {
    Name = "I1"
    }
   0.recorder2_0([450,900],0,0,730)
    {
    FName = "stn1"
    FFMT = "2"
    Rstep = "50"
    Mfilter = "0"
    FREQ = "1"
    StnN = "EMTDC_Simulation"
    DevNo = "1"
    NChA = "6"
    NChD = "1"
    ABFMT = "0"
    MFILE = "0"
    NxHdr = "0"
    AMin = "0"
    AMax = "4096"
    ENTCAP = "0"
    Hdr1 = "Extra_Line_1"
    Hdr2 = "Extra_Line_2"
    Hdr3 = "Extra_Line_3"
    Hdr4 = "Extra_Line_4"
    Hdr5 = "Extra_Line_5"
    NA1 = "V1a"
    DA1 = "A1"
    VS1 = "0"
    VT1 = "0"
    UN1 = "A1"
    PH1 = "0"
    TR1 = "2"
    CT1 = "A1"
    NA2 = "V1b"
    DA2 = "A2"
    VS2 = "0"
    VT2 = "0"
    UN2 = "A2"
    PH2 = "0"
    TR2 = "2"
    CT2 = "A2"
    NA3 = "V1c"
    DA3 = "A3"
    VS3 = "0"
    VT3 = "0"
    UN3 = "A3"
    PH3 = "0"
    TR3 = "2"
    CT3 = "A3"
    NA4 = "I1a"
    DA4 = "A4"
    VS4 = "0"
    VT4 = "1"
    UN4 = "A4"
    PH4 = "0"
    TR4 = "2.5"
    CT4 = "A4"
    NA5 = "I1b"
    DA5 = "A5"
    VS5 = "0"
    VT5 = "1"
    UN5 = "A5"
    PH5 = "0"
    TR5 = "2.5"
    CT5 = "A5"
    NA6 = "I1c"
    DA6 = "A6"
    VS6 = "0"
    VT6 = "1"
    UN6 = "A6"
    PH6 = "0"
    TR6 = "2.5"
    CT6 = "A6"
    NA7 = "A7"
    DA7 = "A7"
    VS7 = "0"
    VT7 = "0"
    UN7 = "A7"
    PH7 = "0"
    TR7 = "1"
    CT7 = "A7"
    NA8 = "A8"
    DA8 = "A8"
    VS8 = "0"
    VT8 = "0"
    UN8 = "A8"
    PH8 = "0"
    TR8 = "1"
    CT8 = "A8"
    NA9 = "A9"
    DA9 = "A9"
    VS9 = "0"
    VT9 = "0"
    UN9 = "A9"
    PH9 = "0"
    TR9 = "1"
    CT9 = "A9"
    NA10 = "A10"
    DA10 = "A10"
    VS10 = "0"
    VT10 = "0"
    UN10 = "A10"
    PH10 = "0"
    TR10 = "1"
    CT10 = "A10"
    NA11 = "A11"
    DA11 = "A11"
    VS11 = "0"
    VT11 = "0"
    UN11 = "A11"
    PH11 = "0"
    TR11 = "1"
    CT11 = "A11"
    NA12 = "A12"
    DA12 = "A12"
    VS12 = "0"
    VT12 = "0"
    UN12 = "A12"
    PH12 = "0"
    TR12 = "1.0"
    CT12 = "A12"
    ND1 = "D1"
    DD1 = "D1"
    NT1 = "0"
    ND2 = "D2"
    DD2 = "D2"
    NT2 = "0"
    ND3 = "D3"
    DD3 = "D3"
    NT3 = "0"
    ND4 = "D4"
    DD4 = "D4"
    NT4 = "0"
    ND5 = "D5"
    DD5 = "D5"
    NT5 = "0"
    ND6 = "D6"
    DD6 = "D6"
    NT6 = "0"
    ND7 = "D7"
    DD7 = "D7"
    NT7 = "0"
    ND8 = "D8"
    DD8 = "D8"
    NT8 = "0"
    ND9 = "D9"
    DD9 = "D9"
    NT9 = "0"
    ND10 = "D10"
    DD10 = "D10"
    NT10 = "0"
    ND11 = "D11"
    DD11 = "D11"
    NT11 = "0"
    ND12 = "D12"
    DD12 = "D12"
    NT12 = "0"
    ND13 = "D13"
    DD13 = "D13"
    NT13 = "0"
    ND14 = "D14"
    DD14 = "D14"
    NT14 = "0"
    ND15 = "D15"
    DD15 = "D15"
    NT15 = "0"
    ND16 = "D16"
    DD16 = "D16"
    NT16 = "0"
    }
   0.datalabel([378,1044],6,0,-1)
    {
    Name = "V2A"
    }
   0.recorder2_0([450,1116],0,0,630)
    {
    FName = "stn2"
    FFMT = "2"
    Rstep = "50"
    Mfilter = "0"
    FREQ = "1"
    StnN = "EMTDC_Simulation"
    DevNo = "2"
    NChA = "6"
    NChD = "1"
    ABFMT = "0"
    MFILE = "0"
    NxHdr = "0"
    AMin = "0"
    AMax = "4096"
    ENTCAP = "0"
    Hdr1 = "Extra_Line_1"
    Hdr2 = "Extra_Line_2"
    Hdr3 = "Extra_Line_3"
    Hdr4 = "Extra_Line_4"
    Hdr5 = "Extra_Line_5"
    NA1 = "V2a"
    DA1 = "A1"
    VS1 = "0"
    VT1 = "0"
    UN1 = "A1"
    PH1 = "0"
    TR1 = "2"
    CT1 = "A1"
    NA2 = "V2b"
    DA2 = "A2"
    VS2 = "0"
    VT2 = "0"
    UN2 = "A2"
    PH2 = "0"
    TR2 = "2"
    CT2 = "A2"
    NA3 = "V2c"
    DA3 = "A3"
    VS3 = "0"
    VT3 = "0"
    UN3 = "A3"
    PH3 = "0"
    TR3 = "2"
    CT3 = "A3"
    NA4 = "I2a"
    DA4 = "A4"
    VS4 = "0"
    VT4 = "1"
    UN4 = "A4"
    PH4 = "0"
    TR4 = ".4"
    CT4 = "A4"
    NA5 = "I2b"
    DA5 = "A5"
    VS5 = "0"
    VT5 = "1"
    UN5 = "A5"
    PH5 = "0"
    TR5 = ".4"
    CT5 = "A5"
    NA6 = "I2c"
    DA6 = "A6"
    VS6 = "0"
    VT6 = "1"
    UN6 = "A6"
    PH6 = "0"
    TR6 = ".4"
    CT6 = "A6"
    NA7 = "A7"
    DA7 = "A7"
    VS7 = "0"
    VT7 = "0"
    UN7 = "A7"
    PH7 = "0"
    TR7 = "1"
    CT7 = "A7"
    NA8 = "A8"
    DA8 = "A8"
    VS8 = "0"
    VT8 = "0"
    UN8 = "A8"
    PH8 = "0"
    TR8 = "1"
    CT8 = "A8"
    NA9 = "A9"
    DA9 = "A9"
    VS9 = "0"
    VT9 = "0"
    UN9 = "A9"
    PH9 = "0"
    TR9 = "1"
    CT9 = "A9"
    NA10 = "A10"
    DA10 = "A10"
    VS10 = "0"
    VT10 = "0"
    UN10 = "A10"
    PH10 = "0"
    TR10 = "1"
    CT10 = "A10"
    NA11 = "A11"
    DA11 = "A11"
    VS11 = "0"
    VT11 = "0"
    UN11 = "A11"
    PH11 = "0"
    TR11 = "1"
    CT11 = "A11"
    NA12 = "A12"
    DA12 = "A12"
    VS12 = "0"
    VT12 = "0"
    UN12 = "A12"
    PH12 = "0"
    TR12 = "1.0"
    CT12 = "A12"
    ND1 = "D1"
    DD1 = "D1"
    NT1 = "0"
    ND2 = "D2"
    DD2 = "D2"
    NT2 = "0"
    ND3 = "D3"
    DD3 = "D3"
    NT3 = "0"
    ND4 = "D4"
    DD4 = "D4"
    NT4 = "0"
    ND5 = "D5"
    DD5 = "D5"
    NT5 = "0"
    ND6 = "D6"
    DD6 = "D6"
    NT6 = "0"
    ND7 = "D7"
    DD7 = "D7"
    NT7 = "0"
    ND8 = "D8"
    DD8 = "D8"
    NT8 = "0"
    ND9 = "D9"
    DD9 = "D9"
    NT9 = "0"
    ND10 = "D10"
    DD10 = "D10"
    NT10 = "0"
    ND11 = "D11"
    DD11 = "D11"
    NT11 = "0"
    ND12 = "D12"
    DD12 = "D12"
    NT12 = "0"
    ND13 = "D13"
    DD13 = "D13"
    NT13 = "0"
    ND14 = "D14"
    DD14 = "D14"
    NT14 = "0"
    ND15 = "D15"
    DD15 = "D15"
    NT15 = "0"
    ND16 = "D16"
    DD16 = "D16"
    NT16 = "0"
    }
   -Wire-([1278,126],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Wire-([1314,1116],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([954,1080],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   0.datalabel([954,1080],0,0,-1)
    {
    Name = "I1B"
    }
   -Wire-([954,1116],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   0.datalabel([954,1116],0,0,-1)
    {
    Name = "I1C"
    }
   -Wire-([954,1044],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([936,1044],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([936,1080],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([936,1116],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   0.pgb([972,954],0,38419552,200)
    {
    Name = "V1b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.pgb([1368,1080],0,38421248,530)
    {
    Name = "I2b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.pgb([1494,1080],0,38423240,510)
    {
    Name = "Q2"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "MVAR"
    mrun = "0"
    Pol = "0"
    Min = "-30"
    Max = "30"
    }
   0.pgb([1368,954],0,38425232,280)
    {
    Name = "V2b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.pgb([972,990],0,38427224,260)
    {
    Name = "V1c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.pgb([1098,1044],0,38429216,640)
    {
    Name = "P1"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "MW"
    mrun = "0"
    Pol = "0"
    Min = "-150"
    Max = "150"
    }
   0.pgb([1368,990],0,38431208,300)
    {
    Name = "V2c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.pgb([1494,990],0,38433200,660)
    {
    Name = "Br2c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-0.1"
    Max = "0.1"
    }
   0.pgb([1098,1152],0,38435104,480)
    {
    Name = "S1Q"
    Group = ""
    Display = "0"
    Scale = "1"
    Units = "MVAR"
    mrun = "0"
    Pol = "0"
    Min = "-100"
    Max = "100"
    }
   0.pgb([972,1044],0,38437096,650)
    {
    Name = "I1"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-3.0"
    Max = "3.0"
    }
   -Wire-([468,450],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([756,450],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   -Sticky-([972,540],0)
    {
    Name = ""
    Font = 1
    Bounds = 972,540,1062,576
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "SUBSTATION 2"
    }
   0.doblestate([1422,108],0,0,830)
    {
    filename = "out1.ss1"
    Cmnt = "Case 1 Station 1"
    NPreF = "300"
    NFlt = "600"
    NPostF = "60"
    PostZero = "0"
    F = "1"
    CTPT = "1"
    CTP = "400"
    CTS = "1"
    PTP = "2000"
    PTS = "1"
    Tpre = "10.0 [ms]"
    TFlt = "50.0 [ms]"
    Tpost = "50.0 [ms]"
    }
   0.datalabel([1278,126],2,0,-1)
    {
    Name = "V1"
    }
   0.datalabel([1278,234],2,0,-1)
    {
    Name = "V2"
    }
   -SrcFile-([1476,90],0)
    {
   Name = "\\case1_state.emt\\out1.ss1"
    }
   -SrcFile-([1476,198],0)
    {
   Name = "\\case1_state.emt\\out2.ss1"
    }
   0.doblestate([1422,216],0,0,820)
    {
    filename = "out2.ss1"
    Cmnt = "Case 1 Station 2"
    NPreF = "300"
    NFlt = "600"
    NPostF = "60"
    PostZero = "0"
    F = "1"
    CTPT = "1"
    CTP = "400"
    CTS = "1"
    PTP = "2000"
    PTS = "1"
    Tpre = "10.0 [ms]"
    TFlt = "50.0 [ms]"
    Tpost = "50.0 [ms]"
    }
   -Wire-([936,1098],0,0,-1)
    {
    Vertex="0,0;0,18"
    }
   -TLine-([504,450],0,21469480,-1)
    {
    Name = "LINE1"
    Date = 1144440511
    Freq = "$(f)"
    Length = "100.0 [km]"
    Dim = 3
    Mode = 1
    Vertex="0,0;18,0;198,0;216,0"
    PageLayer(A/A4,Landscape,18,[597,467],100)
     {
     0.Line_FrePhase_Options([216,468],0,23229240,-1)
      {
      Interp1 = "1"
      Output = "0"
      Inflen = "0"
      FS = "0.5 [Hz]"
      FE = "1.0E6 [Hz]"
      Numf = "100"
      YMaxP = "20"
      AMaxP = "20"
      YMaxE = "2 [%]"
      AMaxE = "2 [%]"
      xxx = ""
      W1 = "100"
      W2 = "1000"
      W3 = "1"
      }
     0.SequenceInfo([522,198],0,23230448,-1)
      {
      Mode = "0"
      X1 = "3.57448095"
      Y1 = "50.7762676"
      X2 = "3.57448095"
      Y2 = "50.7762676"
      X3 = "36.3152201"
      Y3 = "132.647323"
      X4 = "1.0e-005"
      Y4 = "0.000327117946"
      X5 = "0.0"
      Y5 = "0.0"
      X6 = "1.0e-005"
      Y6 = "0.000232266098"
      M1 = "50.9019279149"
      P1 = "85.9732100966"
      M2 = "50.9019279149"
      P2 = "85.9732100966"
      M3 = "137.528569795"
      P3 = "74.6891426178"
      M4 = "0.000327270760373"
      P4 = "88.249012563"
      M5 = "0.0"
      P5 = "0.0"
      M6 = "0.000232481268665"
      P6 = "87.5347062197"
      }
     0.Line_Tower_3_Delta([702,612],0,36738480,-1)
      {
      TName = "3H5"
      Y = "30 [m]"
      Y2 = "5 [m]"
      XC = "10 [m]"
      X = "0 [m]"
      ShuntG = "1.0E-10 [mho/m]"
      SHSag = "0"
      Transp = "1"
      NG = "2"
      ElimGW = "1"
      CDataType = "1"
      CName = "chukar"
      CLName = "..\\conductor.clb"
      RadiusC = "0.0203454 [m]"
      DCResC = "0.03206 [ohm/km]"
      SAGC = "10 [m]"
      NCondB = "1"
      BundSym = "0"
      SHBund = "1"
      BSP = ".4572 [m]"
      GDataType = "1"
      GName = "1/2\"HighStrengthSteel"
      GLName = "..\\conductor.clb"
      RadiusG = "0.0055245 [m]"
      DCResG = "2.8645 [ohm/km]"
      SAGG = "10 [m]"
      YG = "10 [m]"
      XG = "10 [m]"
      XB1 = "-0.1 [m]"
      YB1 = "0.1 [m]"
      XB2 = "-0.1 [m]"
      YB2 = "0.1 [m]"
      XB3 = "-0.1 [m]"
      YB3 = "0.1 [m]"
      XB4 = "-0.1 [m]"
      YB4 = "0.1 [m]"
      XB5 = "-0.1 [m]"
      YB5 = "0.1 [m]"
      XB6 = "-0.1 [m]"
      YB6 = "0.1 [m]"
      XB7 = "-0.1 [m]"
      YB7 = "0.1 [m]"
      XB8 = "-0.1 [m]"
      YB8 = "0.1 [m]"
      XB9 = "-0.1 [m]"
      YB9 = "0.1 [m]"
      XB10 = "-0.1 [m]"
      YB10 = "0.1 [m]"
      NC1 = "1"
      NC2 = "2"
      NC3 = "3"
      NG1 = "4"
      NG2 = "5"
      }
     0.Line_Ground([630,702],0,36740392,-1)
      {
      GRRES = "100.0 [ohm*m]"
      GPERM = "1.0"
      EarthForm = "0"
      }
     }
    }
   .Plots([1512,558],0,0,70)
    {
    }
   .Controls([1512,666],4,0,370)
    {
    }
   -Sticky-([54,180],0)
    {
    Name = ""
    Font = 1
    Bounds = 54,180,450,288
    Alignment = 0
    Style = 0
    Arrow = 0
    Color = 0,15792890
    Text = "\
This case uses global substiutions.  To change between 50Hz/60Hz. Select Global Substitutions (Ctrl-G).  In the window, change the value of f to the desired frequency.
"
    }
   -Wire-([432,810],0,0,-1)
    {
    Vertex="0,0;-108,0"
    }
   0.datalabel([324,810],2,0,-1)
    {
    Name = "V1"
    }
   0.datalabel([324,1026],2,0,-1)
    {
    Name = "V2"
    }
   0.multimeter([450,450],0,0,10)
    {
    MeasI = "0"
    MeasV = "1"
    MeasP = "0"
    MeasQ = "0"
    RMS = "1"
    MeasPh = "0"
    S = "1.0 [MVA]"
    BaseV = "1.0 [kV]"
    TS = "0.02 [s]"
    Freq = "60.0 [Hz]"
    Dis = "0"
    CurI = ""
    VolI = "V1"
    P = ""
    Q = ""
    Vrms = "V1rms"
    Ph = ""
    hide1 = "0"
    hide2 = "0"
    Pd = ""
    Qd = ""
    Vd = ""
    }
   0.multimeter([774,450],4,0,20)
    {
    MeasI = "0"
    MeasV = "1"
    MeasP = "0"
    MeasQ = "0"
    RMS = "1"
    MeasPh = "0"
    S = "1.0 [MVA]"
    BaseV = "1.0 [kV]"
    TS = "0.02 [s]"
    Freq = "60.0 [Hz]"
    Dis = "0"
    CurI = ""
    VolI = "V2"
    P = ""
    Q = ""
    Vrms = "V2rms"
    Ph = ""
    hide1 = "0"
    hide2 = "0"
    Pd = ""
    Qd = ""
    Vd = ""
    }
   0.datamerge([576,810],7,0,440)
    {
    N = "3"
    Type = "2"
    Disp = "1"
    }
   -Wire-([540,828],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([486,828],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   0.datalabel([576,810],2,0,-1)
    {
    Name = "I1"
    }
   0.datamerge([576,1026],7,0,430)
    {
    N = "3"
    Type = "2"
    Disp = "1"
    }
   -Wire-([558,1044],0,0,-1)
    {
    Vertex="0,0;-18,0"
    }
   0.datalabel([576,1026],6,0,-1)
    {
    Name = "I2"
    }
   -Wire-([486,1044],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Divider-([36,756],0)
    {
    Size(1512,0)
    3D = 1
    Color = 9
    Style = 0
    Weight = 2
    }
   0.datalabel([1152,828],2,0,-1)
    {
    Name = "V1rms"
    }
   -Wire-([1152,828],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1296,828],2,0,-1)
    {
    Name = "V2rms"
    }
   -Wire-([1296,828],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Divider-([1170,36],0)
    {
    Size(0,720)
    3D = 1
    Color = 9
    Style = 0
    Weight = 2
    }
   }
  }
 }

